#! /usr/bin/python
#This program returns the total number of electrons and a log-file "date time log" that has all the data points;
#spatial measurements in micrometers, time measurements in picoseconds
from sim import *
from datread import *
from pltmod import *
import time
import os
import getpass

if not os.path.exists('log_file'):
	os.makedirs('log_file')

var = input("Enter 3-velocity of incident particle in units of c, (Vx,Vy,Vz):  ")
charge = input("Enter particle charge in units of e: ")

p = Particle(var[0], var[1], -var[2], charge)

for elem in window_list:
	string = "%i) %s \n" % ((window_list.index(elem)+1),elem["name"])
	print string
mat = input("Choose window material by number: ")
material = window_list[mat - 1]

for elem in photocathode_list:
	string = "%i) %s \n" % ((photocathode_list.index(elem)+1),elem["name"])
	print string
pht = input("Choose photocathode by number: ")
photocathode = photocathode_list[pht - 1]
	
nx = input("Choose number of divisions of charged particle path: ")
nlam = input("Choose number of divisions of wavelength of cherenkov light: ")

def timestamp():
	lt = time.localtime(time.time())
	return "%02d.%02d.%04d_%02d:%02d:%02d" % (lt[1], lt[2], lt[0], lt[3], lt[4], lt[5])
	
file_name = "log_file/%s_log.txt" % (timestamp())

program(p, material, photocathode, nx, nlam, file_name)

log = open(file_name,'a')
info = "Simulation was run on %s by user %s\nInitial velocity: (%f, %f, %f), Charge: %ie\nWindow material: %s, Window thickness: %f mm, Index of Refraction (160 nm): %f\nPhotocathode: %s\n" % (timestamp(), getpass.getuser(), var[0], var[1], var[2], charge, material["name"], 1000*material["d"], n(160, material), photocathode["name"])
info2 = "Number of divisions of charged particle path: %i, Number of divisions of wavelength of cherenkov light: %i\n%f photoelectrons created\n\n" % (nx, nlam, total_electrons())
log.write(info)
log.write(info2)
log.write(file('tmp').read())
log.close()
