import math
from sim import *
from datread import *
import random
#Some important physical constants in mks
c = 299792458.0
mu = 4*(math.pi)*(1e-07)

data = []

#This should spit out the data points needed: It takes inputs: p, particle; material; nx, the number of interations in the path;
#npsi, the number of iterations for the cone of light. This makes physical sense as this is determined by the incoming particle and material
def program(p, material, photocathode, nx, nlam, file_name):
	temp = open('tmp','w')
	temp.close()
	for elem in bound(p, material):
		lam_min = elem[0]
		lam_max = elem[1]
		lam_range = lam_max - lam_min
		dlam = float(lam_range)/float(nlam) #Calculates "infinitesimal" lambda
		for j in range(0,nlam): #Performs sums over acceptable wavelengths
			lam = float(lam_min) + j*dlam
			for i in range(0,nx): #Performs sum over the path
				xy_calc(p, i, nx, lam, dlam, material, photocathode, file_name)
	temp.close()


def prob(p, lam, material, photocathode, photon_distance): #Calculates probability of a photon causing an electron to be released from the photocathode
	return d2N(p, lam, material)*trans(lam, material, photon_distance)*QE(lam, photocathode)

#For given distance (d) along vector (x), for given wavelength (lam)
#gives npsi points on the photocathode plane for incident photons
def xy_calc(p, i, nx, lam, dlam, material, photocathode, file_name):

	#Just some geometric calculations
	unit = [elem/p.s for elem in p.b] #Calculates unit vector	
	cos_th = angle(p, lam) #Cherenkov angle calculation of theta
	sin_th = math.sqrt(1-cos_th**2) #Trigonometric equality of 
	sin_ph = unit[0] #Calculates sin of phi from geometry as the projection of the unit vector of the velocity along the x-axis
	cos_ph = -unit[2] #Same but for cos of phi and along the z-axis	
	
	dist = (material["d"])/cos_ph #Total distance travelled by particle	
	dx = dist/nx #Infinitesimal	
	eventpoint = [elem*i*dx for elem in unit] #Calculates point in (x,y,z) where photon is emitted
	
	psi = 2.0*math.pi*random.random()
	x = i*dx*sin_ph + (nx-i)*dx*cos_ph*((cos_th*sin_ph+sin_th*(math.cos(psi))*cos_ph)/(cos_th*cos_ph-sin_th*(math.cos(psi))*sin_ph))
		
	y = (nx-i)*dx*cos_ph*((sin_th*(math.sin(psi)))/(cos_th*cos_ph-sin_th*(math.cos(psi))*sin_ph))
	
	photon_distance = math.sqrt(((eventpoint[0]-x)**2)+((eventpoint[1]-y)**2)+((eventpoint[2]+material["d"])**2)) #distance from photon emission to cathode hit
		
	emission_time = (i*dx)/(p.s*c)
		
	photon_time = emission_time+((photon_distance)/c) #Calculates total time in picoseconds, from incident particle to photon hitting the cathode
		
	if photon_distance == 0.0:
		omega_angle = 0.0
	else:
		omega_angle = math.acos((math.sqrt(((eventpoint[0]-x)**2)+((eventpoint[1]-y)**2)))/photon_distance) #This is the calculation of the angle omega,		
	# ie, the angle between the photon and the photocathode plane. When omega is Pi/2, the photon is normal to the photocathode
	
	if math.sqrt(((eventpoint[0]*x)**2)+((eventpoint[0]*y)**2)) == 0.0:
		zeta_angle = 0.0
	else:
		zeta_angle = math.acos((eventpoint[0]*x)/math.sqrt(((eventpoint[0]*x)**2)+((eventpoint[0]*y)**2))) #This is calculation of the angle zeta,
	
	string = "%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\n" % (x*(1e6), y*(1e6), photon_time*(1e12), eventpoint[0]*(1e6), -eventpoint[2]*(1e6), emission_time*(1e12), omega_angle, zeta_angle, lam, photon_distance*(1e6), dx*i*(1e6), dlam*dx*prob(p, lam, material, photocathode, photon_distance))
	temp = open('tmp','a')
	temp.write(string)
		
		
def total_electrons(): #Sums over all the probabilities to give us how many electrons total we're getting out
	sum = 0.0
	temp = open('tmp', 'r')
	temp.seek(0)
	string = temp.read()
	li1 = string.split("\n")
	li = []
	for elem in li1:
		li.append(elem.split("\t"))
	temp.close()
	while [''] in li:
		li.remove([''])	
	for elem in li:
		sum = sum + float(elem[-1])
	return sum
		
