from sim import *

#Opens .dat file associated with window material and sends it to a list
def listgen(material=MgF2):
	f = open(material["file"])
	f.seek(0)
	string = f.read()
	li1 = string.split("\n")
	li = []
	for elem in li1:
		li.append(elem.split("\t"))
	f.close()
	while [''] in li:
		li.remove([''])	
	li = [[float(k) for k in elem] for elem in li]
	return li
	
#Uses list from listgen to provide transmittance data for any given wavelength for any given distance
#Since the transmission data, HPFSFusedSilicaStandardGradeCorning.pdf, is in %/cm, we multiply our distance by 100	
def trans(lam, material, dist):
	li = listgen(material)
	if lam <= li[0][0]: return 0
	if lam > li[-1][0]: return ((li[-1][1])/100)**(dist*100)
	for elem in li:
		if elem[0] >= lam:
			i = li.index(elem)
			break
	return ((li[i-1][1] + (lam-li[i-1][0])*((li[i-1][1]-li[i][1])/(li[i-1][0]-li[i][0])))/(100))**(dist*100)

#Slight modification of trans, same reasoning
def QE(lam, photocathode=QE58):		
	li = listgen(photocathode)
	if lam <= li[0][0]: return 0
	if lam > li[-1][0]: return (li[-1][1])		
	for elem in li:
		if elem[0] >= lam:
			i = li.index(elem)
			break
	return (li[i-1][1] + (lam-li[i-1][0])*((li[i-1][1]-li[i][1])/(li[i-1][0]-li[i][0])))/100
